﻿using System;
using System.Collections;
using System.Text.RegularExpressions;
using UTILS;
using System.Threading;
using System.IO;

namespace LFSLapper
{
    partial class LFSClient
    {
        public void loopplayerdetector()
        {
            string ListOfDetectedPlayers;
            int fieldofview = 0;
            int distanceOfview = 0;
            string cmd = "";

            infoPlayer currInfoPlayer;
            foreach (System.Collections.DictionaryEntry de in listOfPlayers.playersUCID)
            {
                currInfoPlayer = (infoPlayer)de.Value;
                if(currInfoPlayer.PlayerDetectorInfo != "")
                {
                    string[] info = currInfoPlayer.PlayerDetectorInfo.ToString().Split('|');
                    //3 values
                    fieldofview = int.Parse(info[0]);
                    distanceOfview = int.Parse(info[1]);
                    cmd = info[2].ToString();

                    ListOfDetectedPlayers = PlayerDetection(currInfoPlayer.userName, fieldofview, distanceOfview);

                    string[] par = new string[2];
                    par[0] = currInfoPlayer.userName;
                    par[1] = ListOfDetectedPlayers;

                        if (ListOfDetectedPlayers != "")
                        {
                            newCfg.executeFunction(cmd, currInfoPlayer, par);
                        }
                }
            }
        }

        public string PlayerDetection(string username, int fov, int dist)
        {
            string detectedplayers = "";
            double Player_one_X = 0;
            double Player_one_Y = 0;
            double Player_one_heading = 0;
            double Player_two_X = 0;
            double Player_two_Y = 0;

            double Radians = 0;
            double Degrees = 0;
            double AngleOfObject = 0;
            float DistOfObject = 0;

            infoPlayer currInfoPlayer;

            //===================================
            //Player1 (Detector)
            //===================================
            infoPlayer Player_one;
            Player_one = listOfPlayers.getPlayerByUserName(username);
            if (Player_one.userName != "")
            {
                Player_one_X = Player_one.x;
                Player_one_Y = Player_one.y;
                Player_one_heading = Player_one.heading;
            }

            foreach (System.Collections.DictionaryEntry de in listOfPlayers.playersUCID)
            {
                currInfoPlayer = (infoPlayer)de.Value;
                //===================================
                //Player2
                //===================================
                infoPlayer Player_two;
                Player_two = listOfPlayers.getPlayerByUserName(currInfoPlayer.userName);
                if (Player_two.userName != Player_one.userName)
                {
                    Player_two_X = Player_two.x;
                    Player_two_Y = Player_two.y;

                    //calculate distance X and Y 
                    int DistX = (int)Player_two_X - (int)Player_one_X;
                    int DistY = (int)Player_two_Y - (int)Player_one_Y;

                    Radians = Math.Atan2(DistY, DistX);
                    //Calculate Degrees + 90(heading car = +90 Y-Axis)
                    Degrees = (Radians * 180 / Math.PI) + 90;

                    //Calculate angleofobject (Degrees - Heading of Player One + 180 degrees)
                    AngleOfObject = ((Degrees - Player_one_heading) + 180);

                    //Adjust AngleOfObject 
                    if (AngleOfObject > 180)
                        AngleOfObject -= 360;

                    if (AngleOfObject < -180)
                        AngleOfObject += 360;

                    DistOfObject = (float)Math.Sqrt((DistX * DistX) + (DistY * DistY));

                    if (((AngleOfObject < fov)&&(AngleOfObject > (fov * -1))) && (DistOfObject < dist))
                    {
                        if (detectedplayers != "")
                            detectedplayers = detectedplayers + "+" + Player_two.userName;
                        else
                            detectedplayers = Player_two.userName;
                    }
                }
            }
            return detectedplayers;
        }
    }
}

